﻿using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using Microsoft.Xrm.Sdk.Workflow;
using System.Linq;
using System.Activities;
using System;
using System.Collections.Generic;
using VA.PPMS.Context;

namespace VA.PPMS.Workflows.PAAction
{

    public sealed class PAExpirationAction : CodeActivity
    {
       
        [Input("ExpirationDateFilter")]
        public InArgument<string> Agreement { get; set; }

        [Output("Count of Expired Agreements")]
        public OutArgument<int> AgreementCount { get; set; }

        protected override void Execute(CodeActivityContext executionContext)
        {
            //Create the tracing service
            ITracingService tracingService = executionContext.GetExtension<ITracingService>();

            //Create the context
            IWorkflowContext context = executionContext.GetExtension<IWorkflowContext>();
            IOrganizationServiceFactory serviceFactory = executionContext.GetExtension<IOrganizationServiceFactory>();
            IOrganizationService service = serviceFactory.CreateOrganizationService(context.UserId);

            tracingService.Trace("Provider Agreement Action");

            //Get the Agreements which are "expired"
            AgreementCount.Set(executionContext, 0);

            DateTime today = DateTime.Now;
            string filterdate = today.ToString("d");

            string  fetchXmlExpiredAgrements = @" 
<fetch top='1' >
  <entity name='ppms_provideragreement' >
    <attribute name='ppms_agreementid' />
    <attribute name='ppms_qualificationdatereview' />
    <attribute name='ppms_effectivedate' />
    <attribute name='ppms_expirationdate' />
    <attribute name='ppms_medicaldirectorsignaturedate' />
    <attribute name='ppms_provideragreementid' />
    <attribute name='ppms_statusswitch' />
    <filter type='and' >
      <filter type='or' >
        <condition attribute='ppms_expirationdate' operator='le' value='" + filterdate + @"' /> 
        <condition attribute='ppms_qualificationdatereview' operator='lt' value= '" + filterdate + @"' />
      </filter>
      <filter type='and' >
        <condition attribute='statecode' operator='eq' value='0' />
        <filter type='or' >
          <condition attribute='ppms_statusswitch' operator='null' />
          <condition attribute='ppms_statusswitch' operator='eq' value='0' />
        </filter>
      </filter>
    </filter>
  </entity>
</fetch>";


            // Retrieving cases using fetchXml
            var agreements = service.RetrieveMultiple(
                new FetchExpression(
                    fetchXmlExpiredAgrements));

            // Null check
            if (agreements == null || agreements?.Entities == null) return;
            // now update each item in turn to trigger the business workflow
            // 
            int i = 0;
            foreach (Entity agreement in agreements.Entities)
            {
                //Update the next birthday field on the entity
                Entity updateEntity = new Entity("ppms_agreement");
                updateEntity.Id = agreement.Id;
                updateEntity["ppms_statusswitch"] = 1;

                service.Update(updateEntity);
                i++;
            }
            AgreementCount.Set(executionContext, i);
        }


    }
}
